
/* A demo to use the "Arduino ccTalk shield" and the ccTalk library in Master role.
   This demo perform a countdown timer in seconds.
   The demo drive the ccTalk Slave "EURODISP BIG" a three digit big display
   and a ccTalk Slave "CCTALK BUTTONS" a three buttons keyboard.
   For a perfect timing use TimerOne library */


/* Include the library for ccTalk */
#include <ccTalk.h>

/* Include the library for Timer 1 */
#include <TimerOne.h>

/* Costructor */ 
ccTalk MyccTalk;

/* Global variables */ 
volatile unsigned int count = 0;
unsigned int precount = 0;
char button;








/*--------------------------------------------*/
/* Demo functions based on the ccTalk library */
/*--------------------------------------------*/

/* Function to write on the ccTalk Slave "EURODISP BIG" 
   Param: address - the slave address - default 70
   Param: number - the number in decimal format (from 0 to 999)
   Param: digit1 - the pattern of digit 1 in flat format (segment by segment) 
   Param: digit2 - the pattern of digit 2 in flat format (segment by segment)
   Param: digit3 - the pattern of digit 3 in flat format (segment by segment)
   Param: mode - bit pattern to control the display (see the table)
   
   |-----------------|--------------------|---------|-----------|-----------|------------|
   | mode.7   mode.6 |  mode.5    mode.4  | mode.3  |  mode.2   |  mode.1   |  mode.0    |
   |-----------------|--------------------|---------|-----------|-----------|------------|
   | Screen Saver    |     Blink Time     | Screen  |   Blink   |  Leading  |  Display   |
   | Delay           |                    | Saver   |           |  Zeroes   |  Mode      |
   |                 |          ON/OFF    |         |           |           |            |
   | 00 =  30 sec.   | 00 =  200ms/200ms  | 0 = OFF | 0 = OFF   | 0 = OFF   | 0 = Decim. |
   | 01 =  60 sec.   | 01 =  500ms/500ms  | 1 = ON  | 1 = ON    | 1 = ON    | 1 = Flat   |
   | 10 =  90 sec.   | 10 =  800ms/400ms  |         |           |           |            |
   | 11 = 120 sec.   | 11 = 1000ms/1000ms |         |           |           |            |
   |-----------------|--------------------|---------|-----------|-----------|------------|
      
   Return: none
   This take about 15 ms */

void WriteEurodispBig(char address, unsigned int number, char digit1, char digit2, char digit3, char mode)
{
  MyccTalk.MasterMessage.DestinationAdd = address;           /* to slave address         */
  MyccTalk.MasterMessage.NumbOfData = 4;                     /* number of data (payload) */
  MyccTalk.MasterMessage.Header = MODIFY_VARIABLE_SET;       /* header command           */
  if((mode & 0x01) == 0)                                     /* if mode decimal ...      */
  {
    MyccTalk.MasterMessage.Data[0] = number % 256;           /* low byte of number       */
    MyccTalk.MasterMessage.Data[1] = number / 256;           /* hight byte of number     */
    MyccTalk.MasterMessage.Data[2] = 0;                      /* 0                        */
  }
  else                                                       /* else flat control        */
  {
    MyccTalk.MasterMessage.Data[0] = digit3;                 /* digit 3                  */
    MyccTalk.MasterMessage.Data[1] = digit2;                 /* digit 2                  */
    MyccTalk.MasterMessage.Data[2] = digit1;                 /* digit 1                  */
  }
  MyccTalk.MasterMessage.Data[3] = mode;                     /* mode                     */
  MyccTalk.ccTalkMasterTxRX();                               /* master slave transaction */
}



/* Function to read the ccTalk Slave "CCTALK BUTTONS" 
   Param: address - the slave address - default 60
   Return: the button pressed - 0 = no button pressed
   This take about 13 ms */

char ReadccTalkButtons(char address)
{
  MyccTalk.MasterMessage.DestinationAdd = address;           /* to slave address          */
  MyccTalk.MasterMessage.NumbOfData = 0;                     /* number of data (payload)  */
  MyccTalk.MasterMessage.Header = REQUEST_VARIABLE_SET;      /* header command            */
  MyccTalk.ccTalkMasterTxRX();                               /* master slave transaction  */
  if(MyccTalk.SlaveMessage.Data[0] == 4) MyccTalk.SlaveMessage.Data[0] = 3;
  return MyccTalk.SlaveMessage.Data[0];                      /* return the button pressed */
}





/* Callback function of Timer1 interrupt.
   decrement count every second
   Return: none */
   
void DecrCounter(void)
{
  if(count) count--;
}




void setup() {
  // put your setup code here, to run once:

  /* Open the serial port at the data rate of 9600 bps. This is the default for ccTalk */
  Serial.begin(9600);

  /* Initialize the timer 1 for a interrupt every one second */
  Timer1.initialize(1000000);
  
  /* Run DecrCounter every one second */
  Timer1.attachInterrupt(DecrCounter);
  

}

void loop() {
  // put your main code here, to run repeatedly:
  
  /*-------------------------------------------------------------------------------*/
  /* In this section you can set the time for the countdown or start the countdown */
  /*-------------------------------------------------------------------------------*/
  
  Timer1.stop();
  
  while(1)
  {
    /* Write a number on the ccTalk Slave "EURODISP BIG" */
    /* Address = 70 : number = count : Blink = OFF */
    /* This take about 15 ms */
    WriteEurodispBig(70, precount, 0, 0, 0, 0);

    /* This delay is mandatory between two consecutive ccTalk transactions */
    /* If there's nothing else to do */
    delay(20);

    /* Read the button pressed */
    /* Address = 60 */
    /* This take about 13 ms */
    button = ReadccTalkButtons(60);
    
    /* This delay is mandatory between two consecutive ccTalk transactions */
    /* If there's nothing else to do */
    delay(20);
    
    /* If button 1 pressed increment the time */
    if((button == 1) && (precount < 300))
    {
      precount += 30;
      WriteEurodispBig(70, precount, 0, 0, 0, 0);
      delay(200);
    }   

    /* If button 2 pressed decrement the time */
    if((button == 2) && (precount > 0))
    {
      precount -= 30;
      WriteEurodispBig(70, precount, 0, 0, 0, 0);
      delay(200);
    }      

    /* If button 3 pressed start the countdown */
    if((button == 3) && (precount > 0))
    {
      break;
    }      
  }

  /*--------------------------------------------------------------*/
  /* This second section perform the countdown with some controls */
  /*--------------------------------------------------------------*/
  
  /* Load the counter and start the interrupt */
  count = precount;
  Timer1.start();
  
  
  /* performs the countdown */
  while(count > 0)
  {
    if(count > 59)
    {
      /* Write a number on the ccTalk Slave "EURODISP BIG" */
      /* Address = 70 : number = count : Blink = OFF */
      /* This take about 15 ms */
      WriteEurodispBig(70, count, 0, 0, 0, 0);
    }
    else
    {
      /* Write a number on the ccTalk Slave "EURODISP BIG" */
      /* Address = 70 : number = count : Blink = ON */
      /* This take about 15 ms */
      WriteEurodispBig(70, count, 0, 0, 0, 20);
    }    
    
    /* This delay is mandatory between two consecutive ccTalk transactions */
    /* If there's nothing else to do */
    delay(20);
    
    /* Read the button pressed */
    /* Address = 60 */
    /* This take about 13 ms */
    button = ReadccTalkButtons(60);
    
    /* If button 1 is pressed the countdown stop */
    if(button == 1) Timer1.stop();
    
    /* If button 2 is pressed the countdown resume */
    if(button == 2) Timer1.resume();
    
    /* If button 3 is pressed the countdown abort */
    if((button == 3) && ((count+3) < precount))
    {
      Timer1.stop();
      break;
    }
    
    /* This delay is mandatory between two consecutive ccTalk transactions */
    /* If there's nothing else to do */
    delay(20);
    
    ///* Show the result of last ccTalk transaction on the serial monitor */
    ///* This is only for debug purpose */
    ///* This take from 20 ms to 30 ms */
    //MyccTalk.ShowLastResult();
  }


  /*-----------------------------------------------------------------*/
  /* This last section show the end of the countdown for ten seconds */
  /*-----------------------------------------------------------------*/
  
  if(button == 0)
  {
  /* Write a number on the ccTalk Slave "EURODISP BIG" */
  /* Address = 70 : number = count : Blink = ON : Leading Zeroes = ON */
  /* This take about 15 ms */
  WriteEurodispBig(70, count, 0, 0, 0, 22);
  delay(10000);
  }
  else
  {
    delay(500);
  }

}







