/* ccTalk.h - ccTalk library for Arduino UNO r3 and the "Arduino ccTalk shield".
   Version 1.0.0  First Release 16/07/2018
   Copyright (c) 2018 Radioforniture Romagnola. All right reserved.

   The "Arduino ccTalk shield" uses the TX pin (pin 0), RX pin (pin 1) 
   and the pin 2 as a digital output to enable/disable the interface. 
   The shield can act as a ccTalk Master or Slave.
   Please pay attention at the jumper J1.
   In the Master role this jumper must be closed to supply power to the Slaves.
   In the Slave role this jumper must be open.  
  
   This library perform the Master role of a ccTalk Master -> Slave transaction.
   Is intended to be use whit the "Arduino ccTalk shield".
   Whit the same shield this library can be extended with the Slave role (to do).

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA */

#ifndef CCTALK_H
#define CCTALK_H

#include "Arduino.h"

/* ccTalk Command Header (NOT COMPLETED) */
#define SIMPLE_POLL                 254
#define REQUEST_VARIABLE_SET        247
#define MODIFY_VARIABLE_SET         165

/* ccTalk message structure */
typedef struct{
char DestinationAdd;
char NumbOfData;
char SourceAdd;
char Header;
char Data[20];
char Checksum;
}ccTalkMessage_t;

/* ccTalk transaction result */
typedef enum{
SLAVE_ACK = 0,
HARDWARE_INTERFACE_TIMEOUT,
SLAVE_TIMEOUT,
SLAVE_CHK_ERROR,
SLAVE_NAK = 5,
SLAVE_BUSY = 6,
}ccTalkResult_t;






/* ccTalk class */
class ccTalk
{
   public:
      
      /* Properties */
      
      /* Master part of the message */
      ccTalkMessage_t MasterMessage;
      
      /* Slave part of the message */
      ccTalkMessage_t SlaveMessage;

      /* Result state of the complete ccTalk transaction */
      ccTalkResult_t  TransactionResult;

      
      /* Methods */

      /* Method to perform the complete ccTalk transaction as a Master (NOT MDCES) */
      void ccTalkMasterTxRX(void);

      /* Method to show the result of last ccTalk transaction on the serial monitor */
      void ShowLastResult(void);

  private:

};













#endif
