
/* ccTalk.cpp - Implementation of the ccTalk library for Arduino UNO r3 and the "Arduino ccTalk shield" */
#include "ccTalk.h"
#include "Arduino.h"


/* Method to perform the complete ccTalk transaction as a Master (NOT MDCES)
   Before the use the MasterMessage properties must be filled with all 
   the necessary data (see the demo).
   Param: none
   Return: none
   Leave the transaction status in the TransactionResult property. */

void ccTalk::ccTalkMasterTxRX(void)
{
  char MasterEco;
  char SlaveChecksum;
  
  /* Master trasmit sections ------------------------------------ */
  MasterMessage.SourceAdd = 1;
    
  /* Prepare the Checksum for the Master message */
  MasterMessage.Checksum = MasterMessage.DestinationAdd;
  MasterMessage.Checksum += MasterMessage.NumbOfData;
  MasterMessage.Checksum += MasterMessage.SourceAdd;
  if(MasterMessage.NumbOfData)
  {
    for(int i=0; i<MasterMessage.NumbOfData; i++)
    {
      MasterMessage.Checksum += MasterMessage.Data[i];
    }
  }
  MasterMessage.Checksum += MasterMessage.Header;
  MasterMessage.Checksum = 256 - MasterMessage.Checksum;

  /* Enable the ccTalk hardware interface */
  pinMode(2, OUTPUT);
  digitalWrite(2, HIGH);

  /* Set the receive (hardware echo) timeout for the Master message */
  Serial.setTimeout(5);
  
  /* Trasmit and receive (hardware echo) the Master message */
  Serial.write(MasterMessage.DestinationAdd);
  if(Serial.readBytes(&MasterEco, 1) == 0)
  {
    TransactionResult = HARDWARE_INTERFACE_TIMEOUT;
    digitalWrite(2, LOW);
    return;
  }
  Serial.write(MasterMessage.NumbOfData);
  Serial.readBytes(&MasterEco, 1);
  Serial.write(MasterMessage.SourceAdd);
  Serial.readBytes(&MasterEco, 1);
  Serial.write(MasterMessage.Header);
  Serial.readBytes(&MasterEco, 1);
  if(MasterMessage.NumbOfData > 0)
  {
    for(int i=0; i<MasterMessage.NumbOfData; i++)
    {
      Serial.write(MasterMessage.Data[i]);
      Serial.readBytes(&MasterEco, 1);
    }
  }
  Serial.write(MasterMessage.Checksum);
  Serial.readBytes(&MasterEco, 1);


  /* Slave receive sections ---------------------------------------- */

  /* Set the receive timeout for the Slave message */
  Serial.setTimeout(30);

  /* Receive the Slave message */
  if(Serial.readBytes(&SlaveMessage.DestinationAdd, 1) == 0)
  {
    TransactionResult = SLAVE_TIMEOUT;
    digitalWrite(2, LOW);
    return;
  }
  Serial.readBytes(&SlaveMessage.NumbOfData, 1);
  Serial.readBytes(&SlaveMessage.SourceAdd, 1);
  Serial.readBytes(&SlaveMessage.Header, 1);
  if(SlaveMessage.NumbOfData > 0)
  {
    for(int i=0; i<SlaveMessage.NumbOfData; i++)
    {
      Serial.readBytes(&SlaveMessage.Data[i], 1);
    }
  }
  Serial.readBytes(&SlaveMessage.Checksum, 1);

  /* Calculates and compare the Slave Checksum */
  SlaveChecksum = SlaveMessage.DestinationAdd;
  SlaveChecksum += SlaveMessage.NumbOfData;
  SlaveChecksum += SlaveMessage.SourceAdd;
  SlaveChecksum += SlaveMessage.Header;
  if(SlaveMessage.NumbOfData > 0)
  {
    for(int i=0; i<SlaveMessage.NumbOfData; i++)
    {
      SlaveChecksum += SlaveMessage.Data[i];
    }
  }
  SlaveChecksum += SlaveMessage.Checksum;
  if(SlaveChecksum)
  {
    TransactionResult = SLAVE_CHK_ERROR;
    digitalWrite(2, LOW);
    return;    
  }

  /* Report the slave Header */
  TransactionResult = SlaveMessage.Header;
  
  /* Disable the ccTalk hardware interface */
  digitalWrite(2, LOW);

}






/* Method to show the result of last ccTalk transaction
   on the serial monitor
   Param: none
   Return: none
   This take from 20 ms to 30 ms */

void ccTalk::ShowLastResult(void)
{
  Serial.println();
  if(TransactionResult == HARDWARE_INTERFACE_TIMEOUT)
  {
    Serial.println("HARDWARE INTERFACE TIMEOUT !!!");
    return;  
  }

  if(TransactionResult == SLAVE_TIMEOUT)
  {
    Serial.println("SLAVE TIMEOUT !!!");  
    return;  
  }

  if(TransactionResult == SLAVE_CHK_ERROR)
  {
    Serial.println("SLAVE CHK ERROR !!!");  
    return;  
  }

  if(TransactionResult == SLAVE_NAK)
  {
    Serial.println("SLAVE NAK !!!");  
    return;  
  }

  if(TransactionResult == SLAVE_BUSY)
  {
    Serial.println("SLAVE BUSY !!!");  
    return;  
  }

  Serial.println("SLAVE ACK !!!");
}








